
#ifndef MEETINGTELEMETRY_CPP
#define MEETINGTELEMETRY_CPP

#include "csfunified/services/interface/TelemetryService.h"
#include "csfunified/services/interface/TelemetryEventNode.h"

#include "MeetingTelemetry.h"

// instance static member of UnifiedFactory
SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> CMeetingTelemetry::UnifiedFactory;

// the CMeetingTelemetry class define
CMeetingTelemetry::CMeetingTelemetry()
	: mpUnifiedFactory(NULL)
{}

CMeetingTelemetry::CMeetingTelemetry(CSFUnified::UnifiedFactory *pUnifiedFactory)
	: mpUnifiedFactory(pUnifiedFactory)
{}

CMeetingTelemetry::CMeetingTelemetry(SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> unifiedFactory)
	: mpUnifiedFactory(NULL)
{
	UnifiedFactory = unifiedFactory;
}

CMeetingTelemetry::CMeetingTelemetry(const CMeetingTelemetry &ins)
	: mpUnifiedFactory(ins.mpUnifiedFactory),
	mMembers(ins.mMembers)
{}

CMeetingTelemetry::~CMeetingTelemetry()
{}

bool CMeetingTelemetry::upload(std::string rootName)
{
	CSFUnified::UnifiedFactory *pUnifiedFactory = NULL;
	if (mpUnifiedFactory != NULL)
	{
		pUnifiedFactory = mpUnifiedFactory;
	}
	else if (UnifiedFactory != NULL){
		pUnifiedFactory = UnifiedFactory.get();
	}
	else{
		return false;
	}

	if (mMembers.empty() != true && rootName.empty() != true)
	{
		SMART_PTR_NS::shared_ptr<CSFUnified::TelemetryService> pTelemetryService = pUnifiedFactory->getService<CSFUnified::TelemetryService>();
		if (pTelemetryService != NULL)
		{
			SMART_PTR_NS::shared_ptr<CSFUnified::TelemetryEventNode> root = pTelemetryService->createEmptyNode();
			if (root != NULL)
			{
				for (std::list<std::pair<std::string, std::string> >::iterator it = mMembers.begin(); it != mMembers.end(); it++)
				{
					root->attachString((*it).first, (*it).second);
				}
				pTelemetryService->sendEvent(root, rootName);
				return true;
			}
		}
	}
	return false;
}

bool CMeetingTelemetry::addMember(std::string memberName, std::string memberValue)
{
	if (memberName.empty() == true)
	{
		return false;
	}
	for (std::list<std::pair<std::string, std::string> >::iterator it = mMembers.begin(); it != mMembers.end(); it++)
	{
		if ((*it).first == memberName)
		{
			return false;
		}
	}
	std::pair<std::string, std::string> pa(memberName, memberValue);
	mMembers.push_back(pa);
	return true;
}

bool CMeetingTelemetry::delMember(std::string memberName)
{
	for (std::list<std::pair<std::string, std::string> >::iterator it = mMembers.begin(); it != mMembers.end(); it++)
	{
		if ((*it).first == memberName)
		{
			mMembers.erase(it);
			return true;
		}
	}
	return false;
}

#endif // MEETINGTELEMETRY_CPP